/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.economy.networking.messages;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.UUID;
import net.impactdev.impactor.api.economy.EconomyService;
import net.impactdev.impactor.api.economy.currency.Currency;
import net.impactdev.impactor.api.economy.transactions.EconomyTransferTransaction;
import net.impactdev.impactor.core.economy.networking.messages.Message;
import net.impactdev.impactor.core.economy.transactions.context.TransferTransactionContext;
import net.impactdev.json.JObject;
import net.kyori.adventure.key.Key;
import org.jetbrains.annotations.NotNull;

public class TransferTransactionMessage
implements Message {
    public static final Key KEY = Key.key((String)"impactor:transaction/transfer");
    private final UUID id;
    private final TransferTransactionContext transaction;

    public TransferTransactionMessage(UUID id, EconomyTransferTransaction transaction) {
        this.id = id;
        this.transaction = TransferTransactionContext.from(transaction);
    }

    private TransferTransactionMessage(UUID id, TransferTransactionContext context) {
        this.id = id;
        this.transaction = context;
    }

    @Override
    public Key key() {
        return KEY;
    }

    @Override
    @NotNull
    public UUID id() {
        return this.id;
    }

    public TransferTransactionContext context() {
        return this.transaction;
    }

    @Override
    public JsonElement serialized() {
        JObject transaction = new JObject().add("currency", this.transaction.currency().key().asString()).add("amount", this.transaction.amount()).add("from", this.transaction.from().toString()).add("to", this.transaction.to().toString());
        JObject json = new JObject().add("id", this.id.toString()).add("key", this.key().asString()).add("transaction", transaction);
        return json.toJson();
    }

    public static TransferTransactionMessage deserialize(UUID id, JsonElement json) {
        Objects.requireNonNull(json, "json");
        JsonObject content = json.getAsJsonObject();
        Currency currency = EconomyService.instance().currencies().currency(Key.key((String)content.get("currency").getAsString())).orElseThrow(() -> new IllegalStateException("Invalid currency: " + content.get("currency").getAsString()));
        UUID from = UUID.fromString(content.get("from").getAsString());
        UUID to = UUID.fromString(content.get("to").getAsString());
        BigDecimal amount = new BigDecimal(content.get("amount").getAsString());
        return new TransferTransactionMessage(id, new TransferTransactionContext(currency, from, to, amount));
    }
}

